* Target resident piece for Fash ROM Programming.
*
* For Intel Flash Chips only:
* Tested on 28f800CEB and 28f800b3 (d160 /cd930)
* 
*
* Many ideas taken from amdp8.s by ??????? (AMD Flash programming package
* from Motorola MCU Support Freeware files)
*
* And finally - I am still learning 68k Assembly and English - so
* don't blame me  too much. mad@ut.ee
*

                include ipd.inc
*-------
BL_SIZE         equ     $4000           Disk buffer size
*					Can be changed from 1 to 7fff?
TRUE            equ     1
FALSE           equ     0
VECTNR          equ     40              Number of exeptions


NUMNUM          equ     8               Number of numbers in reg d1 to print
* Intel Flash related stuff
PORTC           equ     $fffa41         PortC data register
OEBIT           equ     $06

INTEL_BBFM      equ     $0089           IntelBootBlockFlashROM ID

CLRSTATREG      equ     $0050
FLPROGSETUP     equ     $0040
ARRAYRDMODE     equ     $00ff
IDENTCHIP       equ     $0090
RDSTATUSREG     equ     $0070
ERASESETUP      equ     $0020
ERASECONFIRM    equ     $00d0

*Staus Reg Bits
WSMS            equ     $07
ESS             equ     $06
ES              equ     $05
DWS             equ     $04
VPPS            equ     $03

*
*	28LV64 status bits
PLTS            equ     5               PageLoadTimerStatusBit
TB              equ     6               TogleBit
DP		equ	7		Data Polling Bit
*-------
START           dc.l    ProgStart
VECTORS         ds.l    VECTNR
FILE            ds.l    1

* There are probably too many memory variables for
* this simple task

BaseA           ds.l    1               Base address for EEPROM
DataLen         ds.l    1               Lenght of data readed from disk
BlockA          ds.l    1               Current EEPROM Block Address
LastBlock       ds.l    2               LastBlock Indicator
StartMsg        dc.b    'Flash ROM Programming',13,10,0
BEndMsg          dc.b    ' OK',13,10,0
EndMsg          dc.b    'Write Complete '
CRLF            dc.b    13,10,0
CIDMsg          dc.b    'Manuf.ID/Chip ID : ',0
FileMode        dc.b    'rb',0          open read only & binary
                ds.w    0
HexPrintBuff    ds.b    10              buffer for hex printout

DataBuffer      ds.b    BL_SIZE+100


*-------
        even

*------- Here begins code

ProgStart
        lea.l   (Stack,pc),a7           A7 - Stack Pointer
        move.l  d0,d6                   Number of arguments
        move.l  a0,a6                   Pointer to arg's

        lea.l   (VECTORS,pc),a1         Initialize vectortable
        movec   A1,VBR                  VBR-VectorBaseRegister
        lea.l   (ExHand,pc),a2
        moveq   #VECTNR-1,d1
ini_e   move.l  a2,(a1)+                All exeptions to one handler...
        dbf     d1,ini_e                ecept:
        lea.l   (BusErr,pc),a2          Extra vector for Bus Error
        lea.l   (VECTORS,pc),a1
        move.l  a2,(8,a1)

        lea.l   (StartMsg,pc),a0        Welcome message
        moveq   #BD_PUTS,d0
        bgnd

*------ check args & open file & get base_address
        cmpi.l  #3,d6
        bne     ERROR1          * Wrong number of parameters

        move.l  (4,a6),a0       1. param. - file name
        lea.l   (FileMode,pc),a1
        moveq   #BD_FOPEN,d0
        bgnd
        tst     d0
        beq     ERROR2          * Cannot open file
        move.l  d0,(FILE,a5)

        move.l  (8,A6),A0
        moveq   #BD_EVAL,d0
        bgnd
        tst     d0
        bne     ERROR3          * Bad Address value
        move.l  d1,(BaseA,a5)
*------

        move.l  d1,(BlockA,a5)
        btst    #0,d1
        bne     ERROR10
        move.l  #FALSE,(LastBlock,a5)

*------ Get & print Chip ID
        lea.l   (CIDMsg,PC),a0
        moveq   #BD_PUTS,d0
        bgnd
        move.l  (BlockA,a5),a0
        bsr     GetFlChipID
        swap    d0
        cmpi.w  #INTEL_BBFM,d0
        bne     ERROR11         * Not Intel Chip - Exiting
        swap    d0
        bsr     PrintHex
        lea.l   (CRLF,PC),a0
        moveq   #BD_PUTS,d0
        bgnd

LoadBuffer
LoadNext
        lea.l   (DataBuffer,pc),a0
        move.l  (FILE,a5),d1
        move.l  #BL_SIZE,d2
        moveq   #BD_FREAD,d0
        bgnd

        tst     d0              Zero bytes or more?
        bne     halfbl          more

        tst.b   (LastBlock,a5)   May it be last and empty block?
        bne     ERROR4           File Read error
        bra     NiceEnd          Empty block

halfbl
        move.l  d0,(DataLen,a5)  DataLen - amount of readed data
        cmp     #BL_SIZE,d0
        beq     G2Pr           If not full block theb it's the last one

lastbl  moveq   #TRUE,d1                Why move.l #TRUE,(LastBlock,a5)
        move.l  d1,(LastBlock,a5)       did not work? (got move #$1,$0 with asm)

G2Pr    move.l  (BlockA,a5),a1          Start Programming
        lea.l   (DataBuffer,pc),a0
        move.l  (DataLen,a5),d1

*       Algorithm: Flash or EEPROM
*       bsr     WriteBlock              EEPROM
        bsr     WriteFlBl               Flash - must be erased before


Verify
        move.l  (BlockA,a5),a1          Is Data written correctly?
        lea.l   (DataBuffer,pc),a0
        move.l  (DataLen,a5),d1
*        bsr     CompareBlocks
        bsr     CompareBlocksW

        tst     d0                      If d0=1 then error
        bne     ERROR5                  Compare Error


* Print  Address of next Block
        move.l  a1,d0
        bsr     PrintHex
        lea.l   (BEndMsg,pc),a0
        moveq   #BD_PUTS,d0
        bgnd

        cmpi.l  #TRUE,(LastBlock,a5)    Really last block?
        beq     NoMoreData
        add.l   #BL_SIZE,(BlockA,a5)    No,
        bra     LoadNext                Lets make another loop

NoMoreData
*------
NiceEnd
        clr.l   d7

        lea.l   (EndMsg,pc),a0          End message
        moveq   #BD_PUTS,d0
        bgnd

        
RealEnd
        bclr    #OEBIT,PORTC            *(#OE = Low - Enbable Flash Output)

        move.l  (FILE,a5),d1
        beq     nullpoint               If no file with given descriptor
        moveq   #BD_FCLOSE,d0
        bgnd

nullpoint

        move    d7,d1                   Exit program
        moveq   #BD_QUIT,d0
        bgnd

* ------ On-Error Exits - Error messages are in .msg file
ERROR1  moveq   #1,d7
        bra     RealEnd
ERROR2  moveq   #2,d7
        bra     RealEnd
ERROR3  moveq   #3,d7
        bra     RealEnd
ERROR4  moveq   #4,d7
        bra     RealEnd
ERROR5  move    a1, d0          *Print error address (address++ really)
        bsr     PrintHex
        moveq   #5,d7
        bra     RealEnd
ERROR6  moveq   #6,d7
        bra     RealEnd
ERROR7  moveq   #7,d7
        bra     RealEnd
ERROR8  moveq   #8,d7
        bra     RealEnd
ERROR9  moveq   #9,d7
        bra     RealEnd
ERROR10 moveq   #10,d7
        bra     RealEnd
ERROR11 moveq   #11,d7
        bra     RealEnd

ExHand  bra     ERROR6          Simply give error on evry exeption

BusErr  bra     ERROR7          Buserror is very common so let's detect it


*------ End of Main Routine

**------ Compare two Blocks of Memory  byte by byte
** In:
** A0 - pointer to 1. memory buffer
** A1 - pointer to 2. block
** D1 - block lenght
** Out:
** D0 - output error code 0 == OK
*CompareBlocks
*       moveq    #1,d0
*       subi.l   #1,d1                * due dbf command
*CompLoop
*       cmp.b (a0)+,(a1)+
*       bne   C_Err
*       dbf   d1,CompLoop
*       clr.l d0
*C_Err  rts

*------ Compare two Blocks of Memory word by word
* In:
* A0 - pointer to 1. memory buffer
* A1 - pointer to 2. block
* D1 - block lenght in bytes
* Out:
* D0 - output error code 0 == OK
CompareBlocksW
       moveq    #1,d0
       lsr.l    #1,d1
       bcs      ERROR10
       subi.w  #1,d1           * because dbf command loop ends @ -1
FCompLoop
       cmp.w (a0)+,(a1)+
       bne   FC_Err
       dbf   d1,FCompLoop
       clr.l d0
FC_Err rts

**------ Write Block to EEPROM
** In:
** A0 - pointer to memory buffer
** A1 - destination address
** D1 - block lenght - 1 or $ffff on exit NB! D- is word not long!
** d0 - used localy
*WriteBlock
*        subi.w  #1,d1           * because dbf command loop ends @ -1
*LoadLoop
*        move.b  (a0)+,(a1)+
*
*        move    a1,d0
*        andi    #$3f,d0
*        beq     BreakLoading    *64 byte border detected - wait
*
*        btst.b  #PLTS,(-1,a1)   *testing page-load timer status
*        bne     BreakLoading    *Write started - Go and wait until it ends
*
*        DBF     D1,LoadLoop
*
*        bra     WrWaitLoop
*
*BreakLoading
*        subi.w  #1,d1           * If in LoadLoop DBF is skipped
*
*WrWaitLoop
*        btst.b  #TB,(-1,A1)     * Make sure that no write cycles are running
*        bne     is_one
*        btst.b  #TB,(-1,A1)
*        beq     brloop
*is_one  btst.b  #TB,(-1,A1)
*        beq     WrWaitLoop
*
*brloop
*        tst     d1
*        bpl     LoadLoop        * if still positive - loop end @ -1
*        rts

*------ Get Flash Chip ID
* A0    base address
* D0    output data - LSW Device ID &  MSW Manuf. ID
GetFlChipID
        bset    #OEBIT,PORTC       *Disable Flash outputs (#OE = high)
        move.w  #IDENTCHIP,(A0)
        bclr    #OEBIT,PORTC       *(#OE = Low)
        move.w  (a0),D0
        swap    d0
        move.w  (2,a0),d0
        bset    #OEBIT,PORTC       *Disable Flash outputs (#OE = high)
        move.w  #ARRAYRDMODE,(A0)
        bclr    #OEBIT,PORTC       *(#OE = Low)
        rts


*------ Write Block to Flash
* In:
* A0 - pointer to memory buffer
* A1 - destination address
* D1 - block lenght - 1 or $ffff on exit NB! D- is word not long!
* d0 - used localy
WriteFlBl
        lsr.l   #1,d1           * d1 - number of bytes -> number of words
        bcs     ERROR10         * Not even number of bytes
        subi.w  #1,d1           * because dbf command loop ends @ -1
        bset    #OEBIT,PORTC       * Disable Flash outputs (#OE = high)
        move.w  #CLRSTATREG,(A1)

FlashProgLoop
        bset    #OEBIT,PORTC       *Disable Flash outputs (#OE = high)
        move.w  #FLPROGSETUP,(a1)
        move.w  (a0)+,(a1)+
        bclr    #OEBIT,PORTC       *(#OE = Low)
WtFlWr  move.w  (-2,a1),d0         * WriteStateMachineStatus OK?
        btst.b  #WSMS,D0
        beq     WtFlWr

        DBF     D1,FlashProgLoop

* Full status check for last written block

        btst.b  #VPPS,D0
        bne     ERROR8
        btst.b  #DWS,D0
        bne     ERROR9
FullChkOK

* Return To read mode

        bset    #OEBIT,PORTC       *Disable Flash outputs (#OE = high)
        move.w  #ARRAYRDMODE,(-2,a1)  * read mode -2 because a1 may be
*                                     * allready out of flash addres space
        bclr    #OEBIT,PORTC       *(#OE = Low - Read Again)

        rts

*-------  PrintHex - Prints 32 bit unsigned value with lot of leading zeros
* d0 value 0 on exit if evrything was ok
* d1,d2, a0  used as temorary varables
        even
PrintHex
        lea.l   (HexPrintBuff,pc),a0
        moveq   #NUMNUM-1,d2
kala1   lsl.l   #1,d0           * there was one strange compiler error
        roxl.l  #1,d1           * label name was needet to change
        lsl.l   #1,d0
        roxl.l  #1,d1
        lsl.l   #1,d0
        roxl.l  #1,d1
        lsl.l   #1,d0
        roxl.l  #1,d1
        andi.w  #$000f,d1

        cmpi.b  #$09,d1
        bls     hb1
        addi.b  #$07,d1
hb1     addi.b  #$30,d1
        move.b  d1,(a0)+
        dbf d2,kala1
        move.b  #$00,(a0)
        lea.l   (HexPrintBuff,pc),a0
        moveq   #BD_PUTS,d0
        bgnd

        rts

        even
*-------  Stack def
        ds.l    60
Stack   ds.l    1

        end
*-------
