* Target resident piece for EEPROM Programming.
*
* Tested on M28LV64 by ST (in Motorola D160 phone) but other
* similar chips like 28c64 will probably work as well.
* Due using big Disk Buffer and Page-Write mode of EEPROM Chip
* it has prety good perfomance. It can be optimized but 1kB/sec
* was currently enough for me
*
* Many ideas taken from amdp8.s by ??????? (AMD Flash programming package
* from Motorola MCU Support Freeware files)
*
* And finally - I am still learning 68k Assembly and English - so
* don't blame me  too much. mad@ut.ee
*

                include ipd.inc
*-------
BL_SIZE         equ     $2010           Disk buffer size
*					Can be changed from 1 to 7fff?
TRUE            equ     1
FALSE           equ     0
VECTNR          equ     40              Number of exeptions
PORTC           equ     $fffa41         PortC data register
*
*	28LV64 status bits
PLTS            equ     5               PageLoadTimerStatusBit
TB              equ     6               TogleBit
DP		equ	7		Data Polling Bit
*-------
START           dc.l    ProgStart
VECTORS         ds.l    VECTNR
FILE            ds.l    1

* There are probably too many memory variables for
* this simple task

BaseA           ds.l    1               Base address for EEPROM
DataLen         ds.l    1               Lenght of data readed from disk
BlockA          ds.l    1               Current EEPROM Block Address
LastBlock       ds.l    2               LastBlock Indicator
StartMsg        dc.b    'EEPROM Programming',13,10,0
EndMsg          dc.b    'OK',13,10,0
FileMode        dc.b    'rb',0          open read only & binary
                ds.w    0
DataBuffer      ds.b    BL_SIZE+100


*-------
        even

*------- Here begins code

ProgStart
        lea.l   (Stack,pc),a7           A7 - Stack Pointer
        move.l  d0,d6                   Number of arguments
        move.l  a0,a6                   Pointer to arg's

        lea.l   (VECTORS,pc),a1         Initialize vectortable
        movec   A1,VBR                  VBR-VectorBaseRegister
        lea.l   (ExHand,pc),a2
        moveq   #VECTNR-1,d1
ini_e   move.l  a2,(a1)+                All exeptions to one handler...
        dbf     d1,ini_e                ecept:
        lea.l   (BusErr,pc),a2          Extra vector for Bus Error
        lea.l   (VECTORS,pc),a1
        move.l  a2,(8,a1)

        lea.l   (StartMsg,pc),a0        Welcome message
        moveq   #BD_PUTS,d0
        bgnd

*------ check args & open file & get base_address
        cmpi.l  #3,d6
        bne     ERROR1          * Wrong number of parameters

        move.l  (4,a6),a0       1. param. - file name
        lea.l   (FileMode,pc),a1
        moveq   #BD_FOPEN,d0
        bgnd
        tst     d0
        beq     ERROR2          * Cannot open file
        move.l  d0,(FILE,a5)

        move.l  (8,A6),A0
        moveq   #BD_EVAL,d0
        bgnd
        tst     d0
        bne     ERROR3          * Bad Address value
        move.l  d1,(BaseA,a5)
*------
        move.l  d1,(BlockA,a5)
        move.l  #FALSE,(LastBlock,a5)

LoadBuffer
LoadNext
        lea.l   (DataBuffer,pc),a0
        move.l  (FILE,a5),d1
        move.l  #BL_SIZE,d2
        moveq   #BD_FREAD,d0
        bgnd

        tst     d0              Zero bytes or more?
        bne     halfbl          more

        tst.b   (LastBlock,a5)   May it be last and empty block?
        bne     ERROR4           File Read error
        bra     NiceEnd          Empty block

halfbl
        move.l  d0,(DataLen,a5)  DataLen - amount of readed data
        cmp     #BL_SIZE,d0
        beq     G2Pr           If not full block theb it's the last one

lastbl  moveq   #TRUE,d1                Why move.l #TRUE,(LastBlock,a5)
        move.l  d1,(LastBlock,a5)       did not work? (got move #$1,$0 with asm)

G2Pr    move.l  (BlockA,a5),a1          Start Programming
        lea.l   (DataBuffer,pc),a0
        move.l  (DataLen,a5),d1
        bsr     WriteBlock
Verify
        move.l  (BlockA,a5),a1          Is Data written correctly?
        lea.l   (DataBuffer,pc),a0
        move.l  (DataLen,a5),d1
        bsr     CompareBlocks
        tst     d0                      If d0=1 then error
        bne     ERROR5                  Compare Error

        cmpi.l  #TRUE,(LastBlock,a5)    Really last block?
        beq     NoMoreData
        add.l   #BL_SIZE,(BlockA,a5)    No,
        bra     LoadNext                Lets make another loop

NoMoreData
*------
NiceEnd
        clr.l   d7

        lea.l   (EndMsg,pc),a0          End message
        moveq   #BD_PUTS,d0
        bgnd

        
RealEnd move.l  (FILE,a5),d1
        beq     nullpoint               If no file with given descriptor
        moveq   #BD_FCLOSE,d0
        bgnd

nullpoint

        move    d7,d1                   Exit program
        moveq   #BD_QUIT,d0
        bgnd

* ------ On-Error Exits - Error messages are in .msg file
ERROR1  moveq   #1,d7
        bra     RealEnd
ERROR2  moveq   #2,d7
        bra     RealEnd
ERROR3  moveq   #3,d7
        bra     RealEnd
ERROR4  moveq   #4,d7
        bra     RealEnd
ERROR5  moveq   #5,d7
        bra     RealEnd
ERROR6  moveq   #6,d7
        bra     RealEnd
ERROR7  moveq   #7,d7
        bra     RealEnd
ERROR8  moveq   #8,d7
        bra     RealEnd
ERROR9  moveq   #9,d7
        bra     RealEnd

ExHand  bra     ERROR6          Simply give error on evry exeption

BusErr  bra     ERROR7          Buserror is very common so let's detect it


*------ End of Main Routine

*------ Compare two Blocks of Memory
* In:
* A0 - pointer to 1. memory buffer
* A1 - pointer to 2. block
* D1 - block lenght
* Out:
* D0 - output error code 0 == OK
CompareBlocks
       moveq #1,d0
       subi.l   #1,d1
CompLoop
       cmp.b (a0)+,(a1)+
       bne   C_Err
       dbf   d1,CompLoop
       clr.l d0
C_Err  rts

*------ Write Block to EEPROM
* In:
* A0 - pointer to memory buffer
* A1 - destination address
* D1 - block lenght - 1 or $ffff on exit NB! D- is word not long!
* d0 - used localy
WriteBlock
        subi.w  #1,d1           * because dbf command loop ends @ -1
LoadLoop
        move.b  (a0)+,(a1)+

        move    a1,d0
        andi    #$3f,d0
        beq     BreakLoading    *64 byte border detected - wait

        btst.b  #PLTS,(-1,a1)   *testing page-load timer status
        bne     BreakLoading    *Write started - Go and wait until it ends
        
        DBF     D1,LoadLoop

        bra     WrWaitLoop

BreakLoading
        subi.w  #1,d1           * If in LoadLoop DBF is skipped

WrWaitLoop                      
        btst.b  #TB,(-1,A1)     * Make sure that no write cycles are running
        bne     is_one
        btst.b  #TB,(-1,A1)
        beq     brloop
is_one  btst.b  #TB,(-1,A1)
        beq     WrWaitLoop
        
brloop
        tst     d1
        bpl     LoadLoop        * if still positive - loop end @ -1
        rts

*-------  Stack def
        ds.l    60
Stack   ds.l    1

        end
*-------
