* Target resident piece for Fash Erasing.
*
                include ipd.inc
*-------
*					Can be changed from 1 to 7fff?
TRUE            equ     1
FALSE           equ     0
VECTNR          equ     40              Number of exeptions


* Intel Flash related stuff
PORTC           equ     $fffa41         PortC data register
OEBIT           equ     $06

INTEL_BBFM      equ     $0089           IntelBootBlockFlashROM ID

K128            equ     $FFFE0000

CLRSTATREG      equ     $0050
FLPROGSETUP     equ     $0040
ARRAYRDMODE     equ     $00ff
IDENTCHIP       equ     $0090
RDSTATUSREG     equ     $0070
ERASESETUP      equ     $0020
ERASECONFIRM    equ     $00d0

CLEARVAL        equ     $ffff

*Staus Reg Bits
WSMS            equ     $07
ESS             equ     $06
ES              equ     $05
DWS             equ     $04
VPPS            equ     $03

*
*	28LV64 status bits
PLTS            equ     5               PageLoadTimerStatusBit
TB              equ     6               TogleBit
DP		equ	7		Data Polling Bit

NUMNUM          EQU     8               Numbers number for PrintHex

*-------
START           dc.l    ProgStart
VECTORS         ds.l    VECTNR
FILE            ds.l    1

* There are probably too many memory variables for
* this simple task

BaseA           ds.l    1               Base address for EEPROM/Flash
StartMsg        dc.b    'Flash ROM erasing',13,10,0
BEndMsg         dc.b    ' OK',13,10,0
EndMsg          dc.b    'Operation Complete '
CRLF            dc.b    13,10,0
CIDMsg          dc.b    'Manuf.ID/Chip ID : ',0
HexPrintBuff    ds.b    10              buffer for hex printout



*-------
        even

*------- Here begins code

ProgStart
        lea.l   (Stack,pc),a7           A7 - Stack Pointer
        move.l  d0,d6                   Number of arguments
        move.l  a0,a6                   Pointer to arg's

        lea.l   (VECTORS,pc),a1         Initialize vectortable
        movec   A1,VBR                  VBR-VectorBaseRegister
        lea.l   (ExHand,pc),a2
        moveq   #VECTNR-1,d1
ini_e   move.l  a2,(a1)+                All exeptions to one handler...
        dbf     d1,ini_e                ecept:
        lea.l   (BusErr,pc),a2          Extra vector for Bus Error
        lea.l   (VECTORS,pc),a1
        move.l  a2,(8,a1)

        lea.l   (StartMsg,pc),a0        Welcome message
        moveq   #BD_PUTS,d0
        bgnd

*------ check args & open file & get base_address
        cmpi.l  #2,d6
        bne     ERROR1          * Wrong number of parameters

        move.l  (4,a6),a0       1. param address
        moveq   #BD_EVAL,d0
        bgnd
        tst     d0
        bne     ERROR3          * Bad Address value

        move.l  d1,(BaseA,a5)
        btst    #0,d1
        bne     ERROR10

*------

*------ Get & print Chip ID
        lea.l   (CIDMsg,PC),a0
        moveq   #BD_PUTS,d0
        bgnd
        move.l  (BaseA,a5),a0
        bsr     GetFlChipID
        swap    d0
        cmpi.w  #INTEL_BBFM,d0
        bne     ERROR11         * Not Intel Chip - Exiting
        swap    d0
        bsr     PrintHex
        lea.l   (CRLF,PC),a0
        moveq   #BD_PUTS,d0
        bgnd

*------ Erase Chip

        move.l  (BaseA,a5),a0
        bsr     ErFlBl

*------
NiceEnd
        clr.l   d7

        lea.l   (EndMsg,pc),a0          End message
        moveq   #BD_PUTS,d0
        bgnd

        
RealEnd
        bclr    #OEBIT,PORTC            *(#OE = Low - Enbable Flash Output)

        move    d7,d1                   Exit program
        moveq   #BD_QUIT,d0
        bgnd


* ------ On-Error Exits - Error messages are in .msg file
ERROR1  moveq   #1,d7
        bra     RealEnd
ERROR2  moveq   #2,d7
        bra     RealEnd
ERROR3  moveq   #3,d7
        bra     RealEnd
ERROR4  moveq   #4,d7
        bra     RealEnd
ERROR5  move    a1, d0
        bra     RealEnd
ERROR6  moveq   #6,d7
        bra     RealEnd
ERROR7  moveq   #7,d7
        bra     RealEnd
ERROR8  moveq   #8,d7
        bra     RealEnd
ERROR9  moveq   #9,d7
        bra     RealEnd
ERROR10 moveq   #10,d7
        bra     RealEnd
ERROR11 moveq   #11,d7
        bra     RealEnd
ERROR12 moveq   #12,d7
        bra     RealEnd
ERROR13 moveq   #13,d7
        bra     RealEnd

ExHand  bra     ERROR6          Simply give error on evry exeption

BusErr  bra     ERROR7          Buserror is very common so let's detect it


*------ End of Main Routine


*------ Get Flash Chip ID
* A0    base address
* D0    output data - LSW Device ID &  MSW Manuf. ID
GetFlChipID
        bset    #OEBIT,PORTC       *Disable Flash outputs (#OE = high)
        move.w  #IDENTCHIP,(A0)
        bclr    #OEBIT,PORTC       *(#OE = Low)
        move.w  (a0),D0
        swap    d0
        move.w  (2,a0),d0
        bset    #OEBIT,PORTC       *Disable Flash outputs (#OE = high)
        move.w  #ARRAYRDMODE,(A0)
        bclr    #OEBIT,PORTC       *(#OE = Low)
        rts

*------ Erase several Flash Rom Blocks *-----------
* it will autodetect blocks with size 128kB or less
* see parameter called K128
* A0 base address   D0 - Temp data
* D1 block lenght in bytes

ErMultiFlBl
       add.l    a0,d1           final address to d1
ClChkLoop
       cmp.w    #CLEARVAL,(A0)+         *is it ffff ?
       beq      uussona
       bsr      ErFlBl
       move.l   a0,d0
       and.l    #K128,d0       * To begin of Block  (128kB Blocks)
       move.l   d0,a0
uussona
       cmp.l    d1,a0
       blt      ClChkLoop       if a0<d1
       rts


*------- Erase single Flash block
* A0 - address, d0-temp data

ErFlBl
* Erase commands
       bset    #OEBIT,PORTC       *Disable Flash outputs (#OE = high)
       move.w  #ERASESETUP,(a0)
       move.w  #ERASECONFIRM,(a0)
       bclr    #OEBIT,PORTC       *(#OE = Low)
* Wait until ready

WtFlEr
       move.w  (a0),d0         * WriteStateMachineStatus OK?
       btst    #WSMS,D0
       beq     WtFlEr

* Full status check after block erase

       btst.b  #VPPS,D0
       bne     ERROR8
       btst.b  #ES,D0
       beq     ErFlChkOK
       btst.b  #DWS,D0
       bne     ERROR12
       bra     ERROR13
ErFlChkOK
       bset    #OEBIT,PORTC       *Disable Flash outputs (#OE = high)
       move.w  #ARRAYRDMODE,(a0)  * read mode
       bclr    #OEBIT,PORTC       *(#OE = Low - Read Again)
       rts


*-------  PrintHex - Prints 32 bit unsigned value with lot of leading zeros
* d0 value 0 on exit if evrything was ok
* d1,d2, a0  used as temorary varables
        even
PrintHex
        lea.l   (HexPrintBuff,pc),a0
        moveq   #NUMNUM-1,d2
kala1   lsl.l   #1,d0           * there was one strange compiler error
        roxl.l  #1,d1           * label name was needet to change
        lsl.l   #1,d0
        roxl.l  #1,d1
        lsl.l   #1,d0
        roxl.l  #1,d1
        lsl.l   #1,d0
        roxl.l  #1,d1
        andi.w  #$000f,d1

        cmpi.b  #$09,d1
        bls     hb1
        addi.b  #$07,d1
hb1     addi.b  #$30,d1
        move.b  d1,(a0)+
        dbf d2,kala1
        move.b  #$00,(a0)
        lea.l   (HexPrintBuff,pc),a0
        moveq   #BD_PUTS,d0
        bgnd

        rts


        even
*-------  Stack def
        ds.l    60
Stack   ds.l    1

        end
*-------
