* Target resident program for BD32.
* to dump memory block into binary file.
* d2d <filename> <begin> <lenght>
* All parameters are requied.
* Program will print # for evry written block - see BL_SIZE.

        include ipd.inc

BL_SIZE         equ     $4000    Block size (Max $7fff DOS/BD32 limit)
NUM_VEC EQU     40      Anzahl Exception Vektoren
*
START	DC.L	PROG_START	Adresse Anfang des Treibers
VEC_TAB DS.L    NUM_VEC Exception Vektoren
FILE    DS.L    1       DOS-Filehandle
BUFFER  DS.W    50      Data-Buffer
base_a  ds.L    1       Memory block start
b_len   ds.L    1       Block Lenght

Start_Msg       DC.B    'Dumping memory to binary file'
                DC.B    13,10,0
EndMsg          DC.B    13,'File written - check it out!',13,10,0

FMODE   DC.B    'wb',0   Files zum Lesen aufmachen
	DS.W	0


PROG_START	LEA.L	(STACK,PC),A7	Stackpointer definieren
	MOVE.L	D0,D7	Anzahl Parameter
	MOVE.L	A0,A6	Pointer auf die Parameter
	CLR.L	(FILE,A5)	Filepointer vorher lschen

*In This program we don't need to capture exceptions
* because main problem - Bus Error - happens in BD_FWRITE
* function and will be detected by system

*Vektortabelle aufbauen
        LEA.L   (VEC_TAB,PC),A1
        MOVEC   A1,VBR  VBR=Anfang Vektortabelle
        LEA.L   (EXCEPT,PC),A2  Adresse Exception Handler
        MOVEQ   #NUM_VEC-1,D1   Anzahl Vektoren (DBF!)
INIT_VEC         MOVE.L A2,(A1)+        Pointer eintragen
        DBF     D1,INIT_VEC
        lea.l   (Buserex,pc),a2  Extra vector for Bus Error
        lea.l   (VEC_TAB,pc),a1
        move.l  a2,(8,a1)



* Start-Message ausgeben
	LEA.L	(Start_Msg,PC),A0
	MOVEQ	#BD_PUTS,D0	function call
	BGND

* Parameter prfen
* Kommando ist der erste Parameter, Filename der zweite
	LEA.L	0,A4	Offset := 0
        CMP.W   #4,D7   Anzahl Parameter
        bne     PAR_ERR wenn nicht 4, dann Fehler

* Jetzt das File ffnen; der zweite Parameter ist der Filename
PAR_OK	MOVE.L	(4,A6),A0	Pointer auf Filename
	LEA.L	(FMODE,PC),A1	File-Modus
	MOVEQ	#BD_FOPEN,D0	function call FOPEN
	BGND
	TST.W	D0
	BEQ	FILE_ERR	Error: File nicht vorhanden
	MOVE.L	D0,(FILE,A5)	Filehandle abspeichern

* Base Address einlesen

        MOVE.L  (8,A6),A0       Pointer auf Base Address
	MOVEQ	#BD_EVAL,D0	function call EVAL Param
	BGND
	TST.W	D0
        BNE     BADR_ERR        Error: Fehler Base Address
        MOVE.L  D1,A4           Offset merken
        move.l  d1,(base_a,A5)

* Lenght einlesen

        MOVE.L  (12,A6),A0    Pointer auf Block Lenght
	MOVEQ	#BD_EVAL,D0	function call EVAL Param
	BGND
	TST.W	D0
        BNE     BLEN_ERR        Error: Fehler im Block Lenght
        MOVE.L  D1,A4           Offset merken
        move.l  d1,(b_len,A5)


* File ist offen, also jetzt - write
        move.l  (base_a,A5),d4
        move.l  (b_len,A5),d5

wr_block
        cmp.l   #BL_SIZE,d5             Determine how big block
        bmi     shorter                 will be written:
        move.l  #BL_SIZE,d3             BL_SIZE or less?
        bra     goprog
shorter move.l  d5,d3

goprog  moveq   #BD_FWRITE,d0           Write block
        move.l  (FILE,A5),d1
        move.l  d3,d2
        move.l  d4,A0
        bgnd
        cmp.l   d3,D0                   Check for file errors
        bne     FILEWR_ERR

* Print # for evry written Block

        move.b    #$23,d1
        moveq   #BD_PUTCHAR,d0
        bgnd

        addi.l  #BL_SIZE,d4             Move offsets
        subi.l  #BL_SIZE,d5             and check was it last block
        bpl     wr_block                If not then next block



* File is written
PROG_END	CLR.L	D7	kein Fehler

CLOSE_END       MOVE.L  (FILE,A5),D1    Filepointer
        BEQ     IST_ZU  If closed don't close it again
        MOVEQ   #BD_FCLOSE,D0   File wieder schlieen
	BGND

* End-Message                   - cr & lf
        LEA.L   (EndMsg,PC),A0
        MOVEQ   #BD_PUTS,D0
        BGND


IST_ZU  MOVE.L  D7,D1   vorheriger Fehler
	MOVEQ	#BD_QUIT,D0	Fertig
	BGND

BADR_ERR        MOVEQ   #1,D7   Fehler im Base Adress
	BRA	CLOSE_END

FILE_ERR        MOVEQ   #3,D7   Fehler beim ffnen des Files
	BRA	CLOSE_END

FILEWR_ERR      MOVEQ   #5,D7   Fehler beim ffnen des Files
        BRA     CLOSE_END

EXCEPT_ERR      MOVEQ   #4,D7   Unknown error
	BRA	CLOSE_END

BLEN_ERR        MOVEQ   #2,D7   Bad Block Lenght
	BRA	CLOSE_END

PAR_ERR         MOVEQ   #6,D7   Anzahl Parameter stimmt nicht
	BRA	CLOSE_END

BUS_ERR         moveq   #7,D7
        bra     CLOSE_END


EXCEPT  bra     EXCEPT_ERR

Buserex bra     BUS_ERR

* Ende des Programms
	DS.W	100	Stack ist 100 Worte gro
STACK	DS.W	1

	END
